% -----------------------------------------------------------------------
% Este script hace una grfica con los errores de truncamiento
% del mtodo de Euler y el Leapfrog para el problema de la desintegracin
% radioactiva en funcin del tamao del paso h.
% -----------------------------------------------------------------------

%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
fexact = @(t,y0) y0*exp(-k*t);
y0=100;
t0=0;
tf=5;
Np=20;  % Nmero de valores en la figura

%Calculamos el mximo error de truncamiento para cada tamao de paso

eEuler=zeros(1,Np);
eLeap=zeros(1,Np);
h=zeros(1,Np);
Nh = 10:10:10*Np;
for j=1:1:Np
    [te,ye]=feuler(fun,t0,tf,y0,Nh(j));
    [tl,yl]=fLeapfrog(fun,t0,tf,y0,Nh(j));
    yp=fexact(te,y0);
    elEuler=abs(yp-ye);
    elLeap=abs(yp-yl);
    eEuler(j)=max(elEuler); % Mximo error de truncamiento del mtodo de Euler
    eLeap(j)=max(elLeap);   % Mximo error de truncamiento del mtodo Leapfrog
    h(j)=(tf-t0)/Nh(j);
end

%Ajustamos los errores del mtodo de Euler de la forma e=c*h

xy=eEuler.*h;
yy=eEuler.*eEuler;
a=sum(yy);
b=sum(xy);
c=a/b;
Eulerfit=c*h;

%Ajustamos los errores del mtodo Leapfrog de la forma e=c*h^2

yy=eLeap.*eLeap;
hsqr=h.*h;
xy=eLeap.*hsqr;
a=sum(yy);
b=sum(xy);
c=a/b;
Leapfit=c*hsqr;

%Representamos la figura

loglog(h,eEuler,'o',h,Eulerfit,'-k',h,eLeap,'+k',h,Leapfit,'-k');
xlabel('h');
ylabel('Error global de truncamiento');
title('Comparativa Euler-Leapfrog');
legend('Euler','E=cte*h (Euler)','Leapfrog','E=cte*h^2 (Leap)','Location','NorthWest');
